CREATE OR REPLACE FUNCTION tartikel.getlagerortchargetot(
   _aknr       varchar,
   _beistell   bool = false,
   _direktlief bool = false,
   _agnr_for_zwischenlagerort varchar = null,
   _forcelgort varchar = null,
   _preferABK  integer = null,

   OUT lgid integer,
   OUT lgort varchar(100),
   OUT lgchnr varchar(100),
   OUT lganztot numeric(12,4)
) RETURNS RECORD AS $$

    --- #12299 [DB-Strukturen] FUNCTION tartikel.getlagerortchargetot - abruf mit altem Funktionsname
    SELECT tartikel.art__lag__lg_anztot__by__inputparams(
       _aknr,
       _beistell,
       _direktlief,
       _agnr_for_zwischenlagerort,
       _forcelgort,
       _preferABK
    );

$$ LANGUAGE sql;

--- #13471 [DB-Strukturen] split_lagerort > TLager.lag__lagort__bereich__split
CREATE OR REPLACE FUNCTION Z_99_Deprecated.split_lagerort(
   IN _lagerort VARCHAR,
   OUT lgort VARCHAR,
   OUT lagort VARCHAR,
   OUT lagbereich VARCHAR
) RETURNS RECORD AS $$
BEGIN
   --
   SELECT * INTO lgort, lagort, lagbereich FROM TLager.lag__lagort__bereich__split( _lagerort );

END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION Z_99_Deprecated.generate_lagerort(lagbereich VARCHAR, lagort VARCHAR) RETURNS VARCHAR AS $$
    SELECT * FROM TLager.lag__lagort__bereich__generate(lagbereich, lagort);
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_Get_Dok_Exists( _dbrid varchar ) RETURNS boolean AS $$
     SELECT TDMS.Dokument__exists__by__dbrid( _dbrid );
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_Get_Dok_Exists_ByKeyWord(
      _kategorie varchar,
      _descr varchar
  )
  RETURNS boolean
  AS $$

      SELECT TDMS.Dokument__exists__by__keyword( _kategorie, _descr );

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetDokID(
      _dbrid varchar,
      _doktype varchar,
      _tablename varchar = null,
      _dokident varchar = null
  )
  RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__by__pd_dbrid__pd_doktype( _dbrid, _doktype, _tablename, _dokident );

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetDokID_ByIdent(
      _dokident varchar,
      _doktype varchar,
      _tablename varchar,
      _dbrid varchar = null
  )
  RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__by__pd_dokident__pd_doktype( _dokident, _doktype, _tablename, _dbrid )
  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetDokID_ByIdent(
      _dokident varchar,
      _doktypes varchar[],
      _tablename varchar
  )
  RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__by__pd_dokident__pd_doktypes( _dokident, _doktypes, _tablename )

 $$ LANGUAGE sql STABLE;

CREATE OR REPLACE FUNCTION z_99_deprecated.DMS_GetStandardDokID( _dbrid varchar ) RETURNS integer
  AS $$

      SELECT TDMS.Dokument__pd_id__standard_pd_print__by__dbrid( _dbrid );
  $$ LANGUAGE sql STABLE;

--- #17765
CREATE OR REPLACE FUNCTION  z_99_deprecated.stklfromwendattodatebyldid(
        _date date,
        _aknr varchar,
        _ldid integer
    ) RETURNS numeric
    AS $$

        SELECT TLager.wendat__w_zugang__by__ld_id__sum__stichtag( _date, _aknr, _ldid );

    $$ LANGUAGE sql STABLE;

CREATE OR REPLACE FUNCTION z_99_deprecated.stklfromwendattodatebyagid(
        _date date,
        _aknr varchar,
        _agid integer
      ) RETURNS numeric
      AS $$

        SELECT TLager.wendat__w_zugang__by__ag_id__sum__stichtag( _date, _aknr, _agid );

    $$ LANGUAGE sql STABLE;
---

CREATE OR REPLACE FUNCTION z_99_deprecated.get_stundenkonto(
      _minr       integer,
      _ende_datum date = current_date
  )
  RETURNS numeric
  AS $$

      SELECT TPersonal.llv__mitpln__ll_stuko__stundenkonto__calc( _minr, _ende_datum )

  $$ LANGUAGE sql STABLE;


CREATE OR REPLACE FUNCTION z_99_deprecated.set_llv_urlaubges(yyyy integer DEFAULT NULL, minr integer DEFAULT NULL) RETURNS VOID
  AS $$
    SELECT tpersonal.llv__urlaub_ges__from__anspruch__set(yyyy, minr);
  $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION z_99_deprecated.mitpln_PresentDays(
      minr integer,
      anfd date,
      endd date = current_date
  )
  RETURNS numeric
  AS $$

     SELECT TPersonal.mitpln__attandance_day__count( minr, anfd, endd )::numeric;
  $$ LANGUAGE sql STABLE;
--
-- siehe: 2021-10-20
-- FUNCTION tpersonal.llv_urlaub_rest
-- FUNCTION tpersonal.llv_urlaub_anspruch
-- FUNCTION tpersonal.ll_urlaub_act

--- #21589
CREATE OR REPLACE FUNCTION z_99_deprecated.user_in_group(
      IN       _usename   varchar,
      VARIADIC _groupname varchar[]
  ) RETURNS boolean AS $$

     SELECT TSystem.roles__user__group__is_in( _usename, VARIADIC _groupname );

 $$ LANGUAGE sql STABLE;

 CREATE OR REPLACE FUNCTION z_99_deprecated.getusers_groups(
      IN _usename varchar
  ) RETURNS SETOF varchar AS $$

     SELECT TSystem.roles__user__groups__get( _usename );

 $$ LANGUAGE sql STABLE;

 CREATE OR REPLACE FUNCTION z_99_deprecated.user_rights_personal(
    IN _usename varchar,
    IN _role    varchar
  ) RETURNS boolean AS $$

     SELECT TSystem.roles__user__rights_personal( _usename, _role );

 $$ LANGUAGE sql STABLE;
---
--- #22345


CREATE OR REPLACE FUNCTION z_99_deprecated.rahmen_minmenge(rahmenagid INTEGER, aknr VARCHAR, aglkn VARCHAR) RETURNS BOOLEAN AS $$
  DECLARE rec RECORD;
          rahmen_infos RECORD;
          minmengeproz NUMERIC;
          multirahmen INTEGER;
  BEGIN

    RETURN ( SELECT tauftg.auftgr__rahmen_info__minmenge__by__r_ag_id__get( rahmenagid, aknr, aglkn ) );

  END $$ LANGUAGE plpgsql STABLE STRICT;


CREATE OR REPLACE FUNCTION z_99_deprecated.checkrahmen_auftg(
    IN  krz         varchar,
    IN  aknr        varchar,
    IN  agnr        varchar,
    OUT _rahmen_ag_id integer,
    OUT _preis      numeric,
    OUT _rabatt     numeric,
    OUT _aknr       varchar,
    OUT _mgc        integer,
    OUT _diffaknr   boolean,
    OUT _has_abzu   boolean
    )
    RETURNS RECORD
    AS $$
    BEGIN

       SELECT ca._rahmen_ag_id, ca._preis , ca._rabatt, ca._aknr, ca._mgc, ca._diffaknr, ca._has_abzu
       INTO _rahmen_ag_id, _preis, _rabatt, _aknr, _mgc, _diffaknr, _has_abzu
       FROM tauftg.auftgr__rahmen_info__data__by__krz__aknr__agnr__get( krz, aknr, agnr ) AS ca;

       RETURN;

    END $$ LANGUAGE plpgsql STABLE;


SELECT true; --SELECT am File Ende

